# Cyber Security
Cybersecurity is the practice of protecting critical systems and sensitive information from digital attacks. Also known as information technology (IT) security, cybersecurity measures are designed to combat threats against networked systems and applications, whether those threats originate from inside or outside of an organization.

In 2020, the average cost of a data breach was USD 3.86 million globally, and USD 8.64 million in the United States. These costs include the expenses of discovering and responding to the breach, the cost of downtime and lost revenue, and the long-term reputational damage to a business and its brand. Cybercriminals target customers’ personally identifiable information (PII) — names, addresses, national identification numbers (e.g., Social Security number in the US, fiscal codes in Italy), and credit card information — and then sell these records in underground digital marketplaces. Compromised PII often leads to a loss of customer trust, the imposition of regulatory fines, and even legal action.

Security system complexity, created by disparate technologies and a lack of in-house expertise, can amplify these costs. But organizations with a comprehensive cybersecurity strategy, governed by best practices and automated using advanced analytics, artificial intelligence (AI) and machine learning, can fight cyberthreats more effectively and reduce the lifecycle and impact of breaches when they occur.

## Cybersecurity Domains
These eight domains, which have been widely accepted within the cybersecurity community, are:

1. **Security & Risk Management**
2. **Asset Security**
3. **Security Engineering**
4. **Communications & Network Security**
5. **Identity & Access Management**
6. **Security Assessment & Testing**
7. **Security Operations**
8. **Software Development Security**

Let’s examine each of these domains in greater detail:

## Security and Risk Management

Security and risk management is the largest domain in CISSP, accounting for 15 percent of the certification examination. This domain provides an overview of information systems security management, and covers:

1. The availability, integrity, and confidentiality of information
2. Principles of security governance
3. Compliance requirements
4. Legal and regulatory issues in information security
5. Information technology procedures and policies
6. Risk-based management concepts

## Asset Security

Accounting for ten percent of the CISSP exam, the domain of asset security includes the physical requirements of information security. Involved within this is:

1. Handling requirements
2. Data security controls
3. Retention periods
4. Privacy
5. Classification/ownership of information and assets

## Security Engineering

Making up 13 percent of the CISSP exam, the domain of security engineering covers the following concepts:

1. Designing and implementing physical security
2. Cryptography
3. Assessing and mitigating system vulnerabilities
4. Security capabilities within information systems
5. Fundamental concepts of security models
6. Engineering processes using secure design principles

## Communications & Network Security

Accounting for 14 percent of the CISSP exam, the domain of communications and network security covers how an organization’s networks are designed and protected. It includes:

1. Secure communication channels
2. Secure network components
3. Secure design principles for network architecture

## Identity & Access Management

Comprising 13 percent of the CISSP exam, the domain of identity and access management involves controlling the way users can access data. Included within this domain are the following concepts:

1. Identity and access provisioning lifecycle
2. Authorization mechanisms
3. Integrating identity as a service
4. Third-party identity services
5. Identification and authentication
6. Physical and logical access to assets

## Security Assessment & Testing

Making up 12 percent of the CISSP exam, the domain of security assessment and testing focuses on the performance, design and analysis of security testing, and includes:

1. Internal and third-party security audits
2. Test outputs
3. Collecting security process data
4. Security control testing
5. Designing and validating assessment and test strategies

## Security Operations

This domain accounts for 13 percent of the CISSP exam, and addresses how plans are put into action. Concepts covered here include:

1. Business continuity
2. Managing physical security
3. Disaster recovery
4. Incident management
5. Applying resource protection techniques
6. Foundational security operations concepts
7. Securing the provision of resources
8. Logging and monitoring activities
9. Requirements for investigation types
10. Understanding and supporting investigations

## Software Development Security

This final domain comprises 10 percent of the CISSP exam, and helps cybersecurity professionals understand, apply and enforce software security. Included within this domain are these concepts:

1. Secure coding guidelines and standards
2. Effectiveness of software security
3. Security controls in development environments
4. Security in the software development life cycle